///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _CMEMPOOL_H
#define _CMEMPOOL_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
	#define _DEBUG_MEMPOOL 1
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

typedef struct _TAG_ALLOC_POOL {
	int iAddress;
	bool bFree;
} ALLOCPOOL, *LPALLOCPOOL;

typedef struct _TAG_USER_ALLOC {
	ALLOCPOOL *AllocPool;

	int iAllocated;
	int iAllocIncrement;
} USERALLOC, *LPUSERALLOC;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class CMemoryPool{

	public:
		#ifdef _DEBUG_MEMPOOL
			bool FreeAll(void);
			int GetMemAllocationCount(void);
			int GetSlotAllocationCount(void);

			bool Free(void *lpMemory);
			bool Destroy(void);
		#else
			void Free(void *lpMemory);
			void Destroy(void);
		#endif

		bool Init(void);
		bool IsDebug(void);
		void *Allocate(const int iSize, const int iCount);
		void *ReAllocate(void *lpMemory, const int iSize);

	//protected:
		#ifdef _DEBUG_MEMPOOL
			int FindFreeAllocSlot(void);
			int GetSlotByAddress(int iAddress);
		#endif

	//private:
		#ifdef _DEBUG_MEMPOOL
			USERALLOC UserAlloc;
			int iUserAllocs;
		#endif

		CRITICAL_SECTION csMemLock;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern CMemoryPool gMem;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
